---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-ISAPI プロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.ISAPI.pas` - ISAPI プロバイダー実装（59行）
- E-02: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（77行）
- E-03: `src/Horse.WebModule.pas` - WebModule実装（118行）
- E-04: `src/Horse.pas` - メインユニット（117行）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HORSE_ISAPI コンパイルディレクティブで有効化 | E-01: 5行目 `{$IF DEFINED(HORSE_ISAPI) AND NOT DEFINED(FPC)}` | ○ |
| C-02 | Web.Win.ISAPIApp を使用 | E-01: 9行目 | ○ |
| C-03 | GetExtensionVersion をエクスポート | E-01: 31行目 | ○ |
| C-04 | HttpExtensionProc をエクスポート | E-01: 32行目 | ○ |
| C-05 | TerminateExtension をエクスポート | E-01: 33行目 | ○ |
| C-06 | CoInitFlags = COINIT_MULTITHREADED | E-01: 37行目 | ○ |
| C-07 | Application.Initialize 呼び出し | E-01: 38行目 | ○ |
| C-08 | WebModuleClass設定 | E-01: 39行目 | ○ |
| C-09 | DoOnListen でコールバック実行 | E-01: 40行目 | ○ |
| C-10 | Application.Run 呼び出し | E-01: 41行目 | ○ |
| C-11 | StopListen 機能なし | E-01: StopListen メソッドの実装なし | ○ |
| C-12 | THorseProviderAbstract を継承 | E-01: 12行目 | ○ |
| C-13 | FPCではサポートされない | E-01: 5行目 `NOT DEFINED(FPC)` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ISAPIエントリポイント関数のエクスポートが正しく記述されているか
- [ ] COINIT_MULTITHREADEDの設定目的が正しく理解されているか
- [ ] Delphi専用である点が明記されているか
